
//
// Raspberry Pi Rackmount
//

$fn=20;
zuschlag=0.3;
hostname="celsius-01";
//
// Rack Abmessungen
//
m6_durchgangsloch=6.4 + zuschlag;
he=(1.75 - 1/32) * 25.4;
lochabstand=1.25 * 25.4;
winkel=15.88;

//
// Raspberry Pi 2 Modell B Abmessungen
//
raspi_x=56;
raspi_y=85;

// Montagelcher M2,5
mount_pos=[ [3.5,      raspi_y - 3.5 - 58], 
            [3.5 + 49, raspi_y - 3.5 - 58], 
            [3.5,      raspi_y - 3.5], 
            [3.5 + 49, raspi_y - 3.5] ];


            
m2_5_durchgangsloch=2.75 + zuschlag;
m2_5_kern_d=2.01 + zuschlag;
m2_5_dk=4.5 + zuschlag;
m2_5_k=2.5 + zuschlag;
standup_d=6.2;
pcb_h=4;

versatz_x=winkel + 30;
platte_d=2;
platte_l=versatz_x + raspi_x + winkel + 40;
deckel_d=2;

mount_pos_deckel=[ [- 4 * deckel_d - 1.3, 20],
                   [raspi_x + 4 * deckel_d + 1.3 + 20, 20],
				   [raspi_x + 4 * deckel_d + 1.3 + 20, raspi_y - 25],
				   [- 4 * deckel_d - 1.3, raspi_y - 25] ]; // Montagelcher M2,5 

strebe=[ [0, 0],
         [he, 0],
	     [0, he] ];

pos_zugentlastung=[ [0, 0],
					[0, 20],
					[5, 0],
					[5, 20] ];

zugentlastung_d=3;					

// Ethernet Durchbruch
ethernet_dim=[16, 14];
ethernet_pos=[10.25 - ethernet_dim[0] / 2, 0, 0];

// USB Durchbrche
usb_dim=[16, 16];
usb_pos_1=[29 - usb_dim[0] / 2, 0, 0];
usb_pos_2=[47 - usb_dim[0] / 2, 0, 0];

// RJ11 Durchbruch
rj11_dim=[16.8, 16]; // breite, hoehe
rj11_pos=[65 - rj11_dim[0] / 2, 0, -4.5];


difference()
{
	union()
	{
		cube([platte_l, platte_d, he]);		// 1 HE Platte

		linear_extrude(platte_d)
			polygon([ [winkel, platte_d],                                                     // links vorn
					  [platte_l, platte_d ],                                                  // rechts vorn
					  [versatz_x + raspi_x + 3 * deckel_d + 20, raspi_y + platte_d + 2* deckel_d], // rechts hinten
					  [winkel, raspi_y + platte_d + 2 * deckel_d] ]);                         // links hinten

		translate([versatz_x, platte_d, platte_d - 0.1])			
			for(pos=mount_pos)
			{
				translate(pos)
				{
					hull()
					{
						cylinder(d=standup_d, h=pcb_h);
						translate([0, -5, 0 ])
							cylinder(d=standup_d, h=0.1);
					}
				}
			}						  
			
		translate([versatz_x, platte_d, platte_d - 0.1])			
			for(pos=mount_pos_deckel)
			{
				translate(pos)
				{
					hull()
					{
						cylinder(d=standup_d, h=pcb_h);
						translate([0, -5, 0 ])
							cylinder(d=standup_d, h=0.1);
					}
				}
			}
			
		translate([20, platte_d, 0])
			rotate([0,-90,0])
				linear_extrude(platte_d)		 
					polygon(strebe);

		translate([platte_l - 15, platte_d, 0])
			rotate([0,-90,0])
				linear_extrude(platte_d)		 
					polygon(strebe);
	}
	// Loecher und Ausbrche
	translate([winkel / 2, -0.5, he / 2 - lochabstand / 2]) // Loch unten
		rotate([-90, 0, 0])
			cylinder(d=m6_durchgangsloch, h=platte_d + 1);
		
	translate([winkel / 2, -0.5, he / 2 + lochabstand / 2]) // Loch oben
		rotate([-90, 0, 0])
			cylinder(d=m6_durchgangsloch, h=platte_d + 1);	

	translate([versatz_x, platte_d, - 0.5])			
		for(pos=mount_pos)
		{
			translate(pos)
		  		cylinder(d=m2_5_durchgangsloch, h=platte_d + pcb_h + 1);
		  	translate(pos)	
		  		cylinder(d=m2_5_dk, h=m2_5_k);
		}

	translate([versatz_x, platte_d, - 0.5])			
		for(pos=mount_pos_deckel)
		{
			translate(pos)
				cylinder(d=m2_5_durchgangsloch, h=platte_d + pcb_h + 1);
			translate(pos)	
				cylinder(d=m2_5_dk, h=m2_5_k);
		}

	translate([versatz_x - 20, raspi_y - 20, -0.5])
		for(pos=pos_zugentlastung)
		{
			translate(pos)
				cylinder(d=zugentlastung_d, h=platte_d + 1);
		}
		
		ethernet();
		usb();
		rj11();
}

module usb()
{
	translate([versatz_x, platte_d + 0.5, platte_d + pcb_h + 1.5])
	{
		translate(usb_pos_1)
			rotate([90, 0, 0])
				linear_extrude(platte_d + 1)
					square(usb_dim);

		translate(usb_pos_2)
			rotate([90, 0, 0])
				linear_extrude(platte_d + 1)
					square(usb_dim);
	}
}

module ethernet()
{
	translate([versatz_x, platte_d + 0.5, platte_d + pcb_h + 0.7])
	translate(ethernet_pos)
		rotate([90, 0, 0])
		linear_extrude(platte_d + 1)
			square(ethernet_dim);
}

module rj11()
{
	translate([versatz_x, platte_d + 0.5, platte_d + pcb_h + 0.7])
		translate(rj11_pos)
			rotate([90, 0, 0])
				linear_extrude(platte_d + 1)
					square(rj11_dim);
}

